package game;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.JOptionPane;


public class StaticBlockManager {
	
	
	
	
	private ArrayList<ArrayList<SolidBlockSprite>> blockMapByColumn;
	private int columns, rows, tileWidth, tileHeight, totalWidth, totalHeight;
	private CustomImageDataII foregroundBackground;
//	private Color foregroundBackgroundTransparent = null;
	
	private CustomImageDataII backgroundBackground;
	private Color unusedColor;
	private Color bgColor;
	
	public StaticBlockManager(boolean isResource, String fileToLoad, PonyPanel ponyPanel) {
		
		tileWidth = 50;
		tileHeight = 50;
		
		
		try {
			
			BufferedReader in = new BufferedReader(new FileReader(fileToLoad));
			
			String inputter = in.readLine();
			
			blockMapByColumn = new ArrayList<ArrayList<SolidBlockSprite>>();
			
			for(int i = 0; i < inputter.length(); i++) {
				blockMapByColumn.add(new ArrayList<SolidBlockSprite>());
				if(inputter.charAt(i) == 'b')
					blockMapByColumn.get(i).add(new SolidBlockSprite(true, "/images/tile.GIF", tileWidth, tileHeight, i * tileWidth + tileWidth/2, tileHeight/2, null, false, ponyPanel));
				else if(inputter.charAt(i) == 'p')
					blockMapByColumn.get(i).add(new SolidBlockSprite(true, "/images/pass.GIF", tileWidth, tileHeight, i * tileWidth + tileWidth/2, tileHeight/2, null, true, ponyPanel));
			}
			
			columns = blockMapByColumn.size();
			
			int currentRow = 1;
			
			while((inputter = in.readLine()) != null) {
				
				for(int i = 0; i < inputter.length(); i++) {
					if(inputter.charAt(i) == 'b') {
						blockMapByColumn.get(i).add(new SolidBlockSprite(true, "/images/tile.GIF", tileWidth, tileHeight, i * tileWidth + tileWidth/2, currentRow * tileHeight + tileHeight/2, null, false, ponyPanel));
					} else if (inputter.charAt(i) == 'p') { 
						blockMapByColumn.get(i).add(new SolidBlockSprite(true, "/images/pass.GIF", tileWidth, tileHeight, i * tileWidth + tileWidth/2, currentRow * tileHeight + tileHeight/2, null, true, ponyPanel));
//						System.out.println("");
					}
				}
				
				currentRow++;
				
			}
			
			rows = currentRow;
			
			//System.out.println("<><>DELME rows: " + rows + ", columns: " + columns);
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			
			JOptionPane.showMessageDialog(null, "Error:  file not found: " + e.getMessage(), "File not found", JOptionPane.ERROR_MESSAGE);
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			
			JOptionPane.showMessageDialog(null, "Input/Output Error:  " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
		}
		
		
		
		
		
	}
	
	
	
	public void drawTheHardWay(Graphics g, PlayerSprite player) {
		
		//System.out.println("<><>DELME =====================================================================");
		
		int column = 0;
		
		if(backgroundBackground != null && backgroundBackground.getImage() != null) {
			backgroundBackground.drawObjectFromUpperLeftCorner(g, 0, 0);
//			g.drawImage(backgroundBackground, 0, 0, null);
		}
		
		
		if (foregroundBackground != null) {
			foregroundBackground.drawObjectIgnoreBounds(g, totalWidth / 2, totalHeight / 2);
//			System.err.println("<><>DELME foregroundBackground was not null!  It should've shown up...");
		} else {
//			System.err.println("<><>DELME it was null!");
//			g.drawImage(foregroundBackground, 0, 0, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT, player.getxPos() - PonyPanel.PLAY_AREA_WIDTH / 2, player.getyPos() - PonyPanel.PANEL_HEIGHT / 2, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT, foregroundBackgroundTransparent, null);
		}
			
		for(ArrayList<SolidBlockSprite> tempList : blockMapByColumn) {
			
//			System.out.println("<><>DELME at column " + column + ", total number of blocks is: " + tempList.size());
			column++;
			for(BlockInterface block : tempList) {
				//you'd think I'd be able to filter out blocks that don't need drawing
				block.draw(g, player, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT);
				
//				System.out.println("<><>DELME now drawing a block at:  x: " + block.getxPos() + ", y: " + block.getyPos());
				
			}
			
		}
		
		
		
	}
	
	
	public BufferedImage drawTheWholeImage(PonyPanel caller) {
		
//		Image rawImage = caller.createImage((columns) * tileWidth, (rows) * tileHeight);
		BufferedImage rawImage = CustomImageDataII.getGC().createCompatibleImage((columns) * tileWidth, (rows) * tileHeight, Transparency.TRANSLUCENT);
		if(rawImage == null) {
//			System.out.println("<><>DELME the image was null!");
			return null;
		}
			
		Graphics g = rawImage.getGraphics();
		if(g == null) {
//			System.out.println("<><>DELME the graphics were null!");
			return null;
		}
		
//		Color bgColor = new Color(0,0,0,0);
		
		g.setColor(unusedColor);
		g.fillRect(0, 0, (columns) * tileWidth, (rows) * tileHeight);

		if (foregroundBackground != null) {
//			foregroundBackground.primeImage(g, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT);
			foregroundBackground.drawObjectIgnoreBounds(g, totalWidth / 2, totalHeight / 2);
//			System.out.println("this pooch was non-null!  hmmm...");
		} else {
			
//			System.out.println("this pooch was null!  I wonder what it was MEANT to be...");
			
		}
//			g.drawImage(foregroundBackground, 0, 0, null);
		
		
		
//		System.out.println("<><>DELME class of the raw image now: " + rawImage.getClass());
		
//		rawImage = CustomImageData.makeColorTransparent(rawImage, Color.red);
//		
//		System.out.println("<><>DELME class of the raw image after: " + rawImage.getClass());
		
		
//		g = rawImage.getGraphics();
		
		int totalTiles = 0;
		
		g.setColor(Color.blue);
		
		for(ArrayList<SolidBlockSprite> tempList : blockMapByColumn) {
			
			for(SolidBlockSprite block : tempList) {
				//you'd think I'd be able to filter out blocks that don't need drawing
				block.drawForInitialImage(g, tileWidth, tileHeight);  //-TILE_WIDTH / 2 ,  -TILE_HEIGHT / 2
//				g.fillRect(block.getxPos()-2, block.getyPos()-2, 4, 4);
				totalTiles++;
			}
			
		}
		
//		System.out.println("<><>DELME totalTiles: " + totalTiles);
		
		
//		return CustomImageDataII.makeColorTransparent(rawImage, unusedColor, caller, (columns) * tileWidth, (rows) * tileHeight);
		return CustomImageDataII.makeImageTransparent(rawImage, unusedColor);
	}
	
	public void primeAllImages(Graphics g) {
		
		
		int column = 1;
		
		for(ArrayList<SolidBlockSprite> tempList : blockMapByColumn) {
			
			for(BlockInterface block : tempList) {
				//you'd think I'd be able to filter out blocks that don't need drawing
				block.primeImage(g);
				
			}
			
//			System.out.println("<><>DELME bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb  in column " + column + ", there are this many blocks: " + tempList.size());
			column++;
		}
		
//		if(foregroundBackground != null) {
//			System.err.println("<><>DELME priming the foregorund...!");
//			foregroundBackground.primeImage(g, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT);
//		} else {
//			System.err.println("<><>DELME couldn't prime the background; it was null!");
//		}
		
//		if(backgroundBackground != null) {
//			g.drawImage(backgroundBackground, -PonyPanel.PLAY_AREA_WIDTH - totalWidth, -PonyPanel.PANEL_HEIGHT - totalHeight, null);
//		}
		
		
	}
	
	
	private int convertXPosIntoIndex(CollidableObject player) {
		
		int xPos = player.getxPos();
		
		return xPos / tileWidth;
		
		
	}
	
	private int convertNextXPosIntoIndex(CollidableObject player) {
		
		int xPos = player.getNextXPos();
		
		return xPos / tileWidth;
		
		
	}
	
	private int convertPlayerXPosIntoIndex(int xPos) {
		
		return xPos / tileWidth;
		
		
	}
	
	public boolean isCollisionWithTiles(CollidableObject player) {
		
		int primeIndex = convertXPosIntoIndex(player);
		int tolerance = Math.max(player.getCollisionWidth() / tileWidth, 1);
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);
		
		ArrayList<SolidBlockSprite> tempList = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			tempList = blockMapByColumn.get(i);
			for(BlockInterface s: tempList) {
				if(!s.isPassThrough() && s.isPlayerSpriteBlocked(player)) {
					return true;
				}
			}
		}
		
		return false;
	}
	
	
	public BlockInterface isCollisionWithTilesReturnRelevantBlock(CollidableObject player) {
		
		int primeIndex = convertXPosIntoIndex(player);
		int tolerance = Math.max(player.getCollisionWidth() / tileWidth, 1);
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);
		
		ArrayList<SolidBlockSprite> tempList = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			tempList = blockMapByColumn.get(i);
			for(BlockInterface s: tempList) {
				if(!s.isPassThrough() && s.isPlayerSpriteBlocked(player)) {
					return s;
				}
			}
		}
		
		return null;
	}
	
	public BlockInterface findFloorBlock(CollidableObject player) {
		
		IntRect playerRect = player.getCurrentPosCollisionRect();
		
//		int playerRectMaxY = (int) playerRect.getMaxY();
		int playerRectCenterY = (int) playerRect.getCenter().y;
		
		int playerX = player.getxPos();
		
		int primeIndex = convertXPosIntoIndex(player);
		int tolerance = Math.max(1, player.getCollisionWidth() / tileWidth);
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);
		
//		System.out.println("<><>DELME                       startIndex " + startIndex + ", endIndex " + endIndex);
		
		ArrayList<SolidBlockSprite> tempList = null;
		BlockInterface baseBlock = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			
			tempList = blockMapByColumn.get(i);
			
			if(tempList.size() > 0) {
				
				BlockInterface block = tempList.get(0);
				
				IntRect blockRect = block.getCollisionRect();
				
				if(playerRect.getMaxX() < blockRect.getMinX() || playerRect.getMinX() > blockRect.getMaxX()) {
					//this is not a column we care about.
					continue;
				}
				
				
			}
			
			
			
			for(BlockInterface s: tempList) {
				
				if(s.getCollisionRectMinY() > playerRectCenterY) {
					if(baseBlock == null) {
						baseBlock = s;
					} else if(baseBlock.getCollisionRectMinY() > s.getCollisionRectMinY()) {
						baseBlock = s;
					}
				}
				
				
			}
		}
		
		
		
		return baseBlock;
	}
	
	

	public BlockInterface findFloorBlockUseNextPos(CollidableObject character) {
		
		IntRect playerRect = character.getNextPosCollisionRect();
		
//		int playerRectMaxY = (int) playerRect.getMaxY();
		int playerRectCenterY = (int) playerRect.getCenter().y;
		
		int playerX = character.getNextXPos();
		
		int primeIndex = convertPlayerXPosIntoIndex(playerX);
		int tolerance = Math.max(1, character.getCollisionWidth() / tileWidth);
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);
		
//		System.out.println("<><>DELME                       startIndex " + startIndex + ", endIndex " + endIndex);
		
		ArrayList<SolidBlockSprite> tempList = null;
		BlockInterface baseBlock = null; //this.getBottomLineBlock()
		
		for(int i = startIndex; i <= endIndex; i++) {
			
			tempList = blockMapByColumn.get(i);
			
			if(tempList.size() > 0) {
				
				BlockInterface block = tempList.get(0);
				
				IntRect blockRect = block.getCollisionRect();
				
				if(playerRect.getMaxX() < blockRect.getMinX() || playerRect.getMinX() > blockRect.getMaxX()) {
					//this is not a column we care about.
					continue;
				}
				
				
			}
			
			
			
			for(BlockInterface s: tempList) {
				
				if(s.getCollisionRectMinY() > playerRectCenterY) {
					if(baseBlock == null) {
						baseBlock = s;
					} else if(baseBlock.getCollisionRectMinY() > s.getCollisionRectMinY()) {
						baseBlock = s;
					}
				}
				
				
			}
		}
		
		
		
		return baseBlock;
	}
	
	
	public BlockInterface findCeilingBlock(CollidableObject player) {
		
		IntRect playerRect = player.getCurrentPosCollisionRect();
				
		int playerX = player.getxPos();
		
		int primeIndex = convertXPosIntoIndex(player);
		int tolerance = player.getCollisionWidth() / tileWidth;
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);

		ArrayList<SolidBlockSprite> tempList = null;
		BlockInterface baseBlock = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			
			tempList = blockMapByColumn.get(i);
			
			if(tempList.size() > 0) {
				
				BlockInterface block = tempList.get(0);
				
				IntRect blockRect = block.getCollisionRect();
				
				if(playerRect.getMaxX() < blockRect.getMinX() || playerRect.getMinX() > blockRect.getMaxX()) {
					//this is not a column we care about.
					continue;
				}
				
				
			}
			
			
			
			for(BlockInterface s: tempList) {
				
				if(s.isPassThrough())
					continue;
				
				if(s.getyPos() < player.getyPos()) {
					if(baseBlock == null) {
						baseBlock = s;
					} else if(baseBlock.getyPos() < s.getyPos()) {
						baseBlock = s;
					}
				}
				
				
			}
		}
		
		
		
		return baseBlock;
	}
	
	public BlockInterface findCeilingBlockUseNextPos(CollidableObject player) {
		
		IntRect playerRect = player.getNextPosCollisionRect();
				
		int playerX = player.getNextXPos();
		
		int primeIndex = convertPlayerXPosIntoIndex(playerX);
		int tolerance = player.getCollisionWidth() / tileWidth;
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);

		ArrayList<SolidBlockSprite> tempList = null;
		BlockInterface baseBlock = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			
			tempList = blockMapByColumn.get(i);
			
			if(tempList.size() > 0) {
				
				BlockInterface block = tempList.get(0);
				
				IntRect blockRect = block.getCollisionRect();
				
				if(playerRect.getMaxX() < blockRect.getMinX() || playerRect.getMinX() > blockRect.getMaxX()) {
					//this is not a column we care about.
					continue;
				}
				
				
			}
			
			
			
			for(BlockInterface s: tempList) {
				
				if(s.isPassThrough())
					continue;
				
				if(s.getCollisionRectMaxY() < player.getNextPosCollisionRect().getMinY()) {//player.getyPos()
					if(baseBlock == null) {
						baseBlock = s;
					} else if(baseBlock.getyPos() < s.getyPos()) {
						baseBlock = s;
					}
				}
				
				
			}
		}
		
		
		
		return baseBlock;
	}
	
	
	public BlockCollisionData isCollisionWithTilesII(CollidableObject player) {
		
		BlockCollisionData returnValue = new BlockCollisionData(player);
		
		int primeIndex = convertXPosIntoIndex(player);
		int tolerance = Math.max(player.getCollisionWidth() / tileWidth, 1);
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);
		
		IntRect playerRect = player.getNextPosCollisionRect();
		
		ArrayList<SolidBlockSprite> tempList = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			tempList = blockMapByColumn.get(i);
			for(BlockInterface s: tempList) {
				if(!s.isPassThrough())
					returnValue.checkCollision(s);
			}
		}
		
		return returnValue;
	}
	
	
	public StaticBlockManager(int isResource, String fileToLoad, PonyPanel ponyPanel, boolean fromFiles) {
		
		tileHeight = -1;
		tileWidth = -1;
		columns = -1;
		rows = -1;
		
		BufferedReader in = null;
		
		try {
			if(fromFiles){
				in = new BufferedReader(new FileReader(fileToLoad));
			} else {
				URL url = LevelData.class.getResource(fileToLoad);
				in = new BufferedReader(new InputStreamReader(url.openStream()));
			}

			readFromFile(in, fileToLoad, "DUMMY!!!!", ponyPanel, fromFiles);
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			
			JOptionPane.showMessageDialog(null, "Error occurred: " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
			
		} finally {
			try { in.close();} catch(Exception e) {}
		}
		
	}
	
	

	public StaticBlockManager() {
		blockMapByColumn = new ArrayList<ArrayList<SolidBlockSprite>>();
		tileHeight = -1;
		tileWidth = -1;
		columns = -1;
		rows = -1;
	}
	
	public void readFromFile(BufferedReader in, String fileToLoad, String roomName, PonyPanel ponyPanel, boolean fromFiles) throws NumberFormatException, IOException {

		boolean tileMapMode = false;

		int currentRow = 1;
		
		
			
		int fileLine = 0;
		
		String inputter = null;
		
		blockMapByColumn = new ArrayList<ArrayList<SolidBlockSprite>>();
		
		HashMap<Character, SolidBlockTemplate> charactersToTileGraphicFilenames = new HashMap<Character, SolidBlockTemplate>();
		
		char tempChar;
		String tempStr;
		SolidBlockTemplate tempTemplate;
		
		
		Color foregroundBackgroundTransparent = null;
		String foregroundFileName = null;
		
		tileWidth = -1;
		tileHeight = -1;
		
		rows = -1;
		columns = -1;
		
		int totalTileRowsRead = 0;
		
		while((inputter = in.readLine()) != null) {
			
			fileLine++;
			
			if(inputter.contains("#")) {
				continue;
			}
			if(inputter.contains("/staticBlocks")) {
//				System.out.println("<><>DELME and that's that for this one!  rows: " +rows + ", columns: " + columns);
				break;
			}
			
			if(tileMapMode) {
				
//				System.out.println("<><>DELME &&&&&&&&&&& now in tileMapMode, inputter is: <<" + inputter + ">>, columns: " + columns + ", rows: " + rows + ", tileWidth: " + tileWidth + ", tileHeight: " + tileHeight + ", charactersToTileGraphicFilenames.size: " + charactersToTileGraphicFilenames.size());
				
//				if(inputter.length() != columns) {
//					System.out.println("Error:  at line " + fileLine + " in the input file " + fileToLoad + ", the total columns wasn't the expected " + columns + ".");
//				}
				
				for(int i = 0; i < inputter.length(); i++) {
					
					tempChar = inputter.charAt(i);
					
					if(!charactersToTileGraphicFilenames.containsKey(tempChar)) {
//						System.out.println("had no template for character '" + Character.toString(tempChar) + "'");
						continue;
					}
					
					tempTemplate = charactersToTileGraphicFilenames.get(tempChar);
					
					
//					if(tempTemplate == null) {
//						System.err.println("found the null:  " + roomName + ", trying to get char: " + tempChar);
//					}
					
					blockMapByColumn.get(i)
						.add(
							tempTemplate.createSolidBlockSprite(i * tileWidth + tileWidth/2, totalTileRowsRead * tileHeight + tileHeight/2));
					
//					blockMap.get(i).add(new SolidBlockSprite(true, "images/" + tempStr + ".GIF", tileWidth, tileHeight, , null, false));
					
//						if(inputter.charAt(i) == 'b') {
//							blockMap.get(i).add(new SolidBlockSprite(true, "images/tile.GIF", TILE_WIDTH, TILE_HEIGHT, i * TILE_WIDTH + TILE_WIDTH/2, currentRow * TILE_HEIGHT + TILE_HEIGHT/2, null, false));
//						} else if (inputter.charAt(i) == 'p') { 
//							blockMap.get(i).add(new SolidBlockSprite(true, "images/pass.GIF", TILE_WIDTH, TILE_HEIGHT, i * TILE_WIDTH + TILE_WIDTH/2, currentRow * TILE_HEIGHT + TILE_HEIGHT/2, null, true));
//						}
				}
				
				totalTileRowsRead++;
				
				if(totalTileRowsRead >= rows) {
					//we're done
					
					if(rows != -1 && columns != -1 && tileHeight != -1 && tileWidth != -1) {
						totalHeight = rows * tileHeight;
						totalWidth = columns * tileWidth;
					}
					
//					System.out.println("Ah, we're leaving the method THIS way.  Okay, then.  So...after it all, totalHeight: " + totalHeight + ", totalWidth: " + totalWidth + ", rows: " + rows + ", columns: " + columns + ", size of blockMap is: " + blockMapByColumn.size() + ", room name: " + roomName + " foreground null? " + (foregroundBackground == null));
					
					break;
				}
				
				
			} else {
				
				if(inputter.contains("blockDef:")) {
					
					//add a tile graphic to the map.
					tempChar = inputter.charAt(9);
					
					tempTemplate = SolidBlockTemplate.readFromBufferedReader(in, tileWidth, tileHeight, ponyPanel, fromFiles, roomName);
					
					charactersToTileGraphicFilenames.put(tempChar, tempTemplate);
					
				} else if(inputter.contains("tileWidth:")) {
					tileWidth = Integer.parseInt(inputter.substring(10).trim());
				} else if(inputter.contains("tileHeight:")) {
					tileHeight = Integer.parseInt(inputter.substring(11).trim());
				} else if(inputter.contains("totalRows:")) {
					rows = Integer.parseInt(inputter.substring(10).trim());
				} else if(inputter.contains("totalColumns:")) {
					columns = Integer.parseInt(inputter.substring(13).trim());
				} else if(inputter.contains("foreground:")) {
					
//					System.err.println("<><>DELME now in the foreground!");
					
					String array[] = inputter.substring(11).split("\\*");
					

					foregroundBackgroundTransparent = CustomImageData.translateFileInStringToColor(array[1].trim());
					
					URL url = RoomData.class.getResource("/images/" + array[0] + ".GIF");
					if(url == null && !fromFiles) {
						continue;
					}
					
//					System.err.println("<><>DELME size of array: " + array.length + "; 0: <<" + array[0] + ">>, 1: <<" + array[1] + ">>");
					
//					ImageIcon ii = new ImageIcon(url);
//					foregroundBackground = new CustomImageData(ii.getImage(), ii.getIconWidth(), ii.getIconHeight(), foregroundBackgroundTransparent, null);
					
					foregroundFileName = array[0];
					
					/*if(fromFiles) {
						foregroundBackground = CustomImageDataIIRepository.loadImage(new File(array[0]), foregroundBackgroundTransparent, ponyPanel, roomName, fileToLoad);
								//new CustomImageDataII(new File(array[0]), foregroundBackgroundTransparent, ponyPanel);
					} else {
						foregroundBackground = CustomImageDataIIRepository.loadImage("/images/" + array[0] + ".GIF", foregroundBackgroundTransparent, ponyPanel, roomName);
								//new CustomImageDataII("/images/" + array[0] + ".GIF", foregroundBackgroundTransparent, ponyPanel);
					}*/
					
//					System.err.println("<><>DELME so is it null? " + (foregroundBackground == null));
					
					
				} else if(inputter.contains("unusedColor:")) {
					unusedColor = CustomImageData.translateFileInStringToColor(inputter.substring(12).trim());
				} else if(inputter.contains("background:")) {
					
//					URL url = RoomData.class.getResource("images/" + inputter.substring(11).trim() + ".GIF");
//					if(url == null) {
//						continue;
//					}
//					ImageIcon ii = new ImageIcon(url);
//					backgroundBackground = ii.getImage();
					
					if(fromFiles) {
						backgroundBackground = CustomImageDataIIRepository.loadImage(new File(inputter.substring(11).trim()), null, ponyPanel, roomName, inputter.substring(11).trim());
								//(new CustomImageDataII(new File(inputter.substring(11).trim()), null, ponyPanel)).getImage();
					} else {
						backgroundBackground = CustomImageDataIIRepository.loadImage("/images/" + inputter.substring(11).trim() + ".GIF", null, ponyPanel, roomName);
//						CustomImageDataII cid2 = new CustomImageDataII("/images/" + inputter.substring(11).trim() + ".GIF", null, ponyPanel);
//						backgroundBackground = cid2.getImage();
					}
				} else if(inputter.contains("tileMap")) {
					tileMapMode = true;
					
					boolean wasError = false;
					
					if(columns == -1) {
//						System.out.println("ERROR:  totalColumns was not set!");
						wasError = true;
					}
					if(rows == -1) {
//						System.out.println("ERROR:  totalRows was not set!");
						wasError = true;
					}
					if(tileWidth == -1) {
//						System.out.println("ERROR:  tileWidth was not set!");
						wasError = true;
					}
					if(tileHeight == -1) {
//						System.out.println("ERROR:  tileHeight was not set!");
						wasError = true;
					}
					if(charactersToTileGraphicFilenames.isEmpty()) {
//						System.out.println("ERROR:  no tile mappings were defined!");
						wasError = true;
					}
					
					if(wasError) {
						return;
					}
					
					
					for(int i = 0; i < columns; i++) {
						blockMapByColumn.add(new ArrayList<SolidBlockSprite>());
					}
					
				}
				
			}
			
//				for(int i = 0; i < inputter.length(); i++) {
//					if(inputter.charAt(i) == 'b') {
//						blockMap.get(i).add(new SolidBlockSprite(true, "images/tile.GIF", TILE_WIDTH, TILE_HEIGHT, i * TILE_WIDTH + TILE_WIDTH/2, currentRow * TILE_HEIGHT + TILE_HEIGHT/2, null, false));
//					} else if (inputter.charAt(i) == 'p') { 
//						blockMap.get(i).add(new SolidBlockSprite(true, "images/pass.GIF", TILE_WIDTH, TILE_HEIGHT, i * TILE_WIDTH + TILE_WIDTH/2, currentRow * TILE_HEIGHT + TILE_HEIGHT/2, null, true));
//					}
//				}
			
			currentRow++;
			
		}
		
//			rows = currentRow;
		
		//System.out.println("<><>DELME rows: " + rows + ", columns: " + columns);
			

		if(rows != -1 && columns != -1 && tileHeight != -1 && tileWidth != -1) {
			totalHeight = rows * tileHeight;
			totalWidth = columns * tileWidth;
//			System.out.println("<><>DELME             -  - - - - - - - --  - -    at the end of the load method for StaticBlockManager, for file " + fileToLoad + ", and the rows are: " + rows + " and the columns are: " + columns);
		} else {
//			System.out.println("<><>DELME        =============================    at the end of the load method for StaticBlockManager, for file " + fileToLoad + ", and something went wrong.  rows " + rows + ", columns " + columns + ", tileWidth " + tileWidth + ", tileHeight: " + tileHeight + ", size of charactersToTileGraphicFilenames: " + charactersToTileGraphicFilenames.size());
		}
		
		
		if(foregroundFileName != null) {
			if(fromFiles) {
				foregroundBackground = CustomImageDataIIRepository.loadImage(new File(foregroundFileName), foregroundBackgroundTransparent, ponyPanel, totalWidth, totalHeight, roomName, foregroundFileName);
			} else {
				foregroundBackground = CustomImageDataIIRepository.loadImage("/images/" + foregroundFileName + ".GIF", foregroundBackgroundTransparent, ponyPanel, totalWidth, totalHeight, roomName);
			}
//		} else {
//			System.out.println("<><>DELME for room " + roomName + ", foregroundBackground");
		}
		
		
//		System.out.println("<><>DELME in any case, the currentRow is set to: " + currentRow + ", and the size of the overall map is: " + this.blockMapByColumn.size() + ", and inputter is: " + inputter + ", and file is: " + fileToLoad);
		
	}



	public Image getBackgroundBackground() {
		return backgroundBackground == null ? null : backgroundBackground.getImage();
	}



	public int getTotalWidth() {
		return totalWidth;
	}



	public int getTotalHeight() {
		return totalHeight;
	}
	
//	public void printAllColumnSizes() {
//		
//		
//		if(blockMapByColumn == null) {
////			System.out.println("SOUND OFF the blockMap is null!");
//		} else {
////			System.out.println("SOUND OFF the blockMap's size is: " + blockMapByColumn.size() + " columns");
//			
//			int i = 1;
//			
//			for(ArrayList<SolidBlockSprite> tempList : blockMapByColumn) {
//				
//				System.out.println("SOUND OFF    for column " + i + ", there are this many blocks: " + tempList.size());
//				
//				i++;
//				
//			}
//			
//		}
//		
//	}
	
	public int getRightWallUseNextPos(CollidableObject collidable, IntRect nextRect) {
		
		int primeIndex = convertNextXPosIntoIndex(collidable);
		
		int tolerance = Math.max(collidable.getCollisionWidth() / tileWidth, 1);
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);
		
		BlockInterface candidate = null;
		
		ArrayList<SolidBlockSprite> tempList = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			tempList = blockMapByColumn.get(i);
			for(BlockInterface s: tempList) {
				if(s.isPassThrough() || s.getxPos() < collidable.getNextXPos() || s.getCollisionRectMaxY() < nextRect.getMinY() || s.getCollisionRectMinY() > nextRect.getMaxY()) {
					continue;
				}
				
				if(candidate == null || s.getxPos() < candidate.getxPos()) {
					candidate = s;
				}
				
			}
		}
		
		if(candidate == null)
			return Integer.MAX_VALUE;
		
		return candidate.getCollisionRectMinX();
		
		
	}
	
	public int getRightWallUseCurrentPos(CollidableObject collidable, IntRect currentRect) {
		
		int primeIndex = convertXPosIntoIndex(collidable);
		
		int tolerance = Math.max(collidable.getCollisionWidth() / tileWidth, 1);
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);
		
		BlockInterface candidate = null;
		
		ArrayList<SolidBlockSprite> tempList = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			tempList = blockMapByColumn.get(i);
			for(BlockInterface s: tempList) {
				if(s.isPassThrough() || s.getxPos() < collidable.getxPos() || s.getCollisionRectMaxY() < currentRect.getMinY() || s.getCollisionRectMinY() > currentRect.getMaxY()) {
					continue;
				}
				
				if(candidate == null || s.getxPos() < candidate.getxPos()) {
					candidate = s;
				}
				
			}
		}

		if(candidate == null)
			return Integer.MAX_VALUE;
		
		return candidate.getCollisionRectMinX();
		
		
	}
	
	public int getLeftWallUseNextPos(CollidableObject collidable, IntRect nextRect) {
		
		int primeIndex = convertNextXPosIntoIndex(collidable);
		
		int tolerance = Math.max(collidable.getCollisionWidth() / tileWidth, 1);
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);
		
		BlockInterface candidate = null;
		
		ArrayList<SolidBlockSprite> tempList = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			tempList = blockMapByColumn.get(i);
			for(BlockInterface s: tempList) {
				if(s.isPassThrough() || s.getxPos() > collidable.getxPos()  || s.getCollisionRectMaxY() < nextRect.getMinY() || s.getCollisionRectMinY() > nextRect.getMaxY()) {
					continue;
				}
				
				if(candidate == null || s.getxPos() > candidate.getxPos()) {
					candidate = s;
				}
				
			}
		}
		
		
		if(candidate == null) {
			return Integer.MIN_VALUE;
		}
		
		
//		System.err.println("<><>DELME getCollisionRectMaxX is: " + candidate.getCollisionRectMaxX() + ", and its xPos is: " + candidate.getxPos());
		return candidate.getCollisionRectMaxX();
		
		
	}
	
	public int getLeftWallUseCurrentPos(CollidableObject collidable, IntRect currentRect) {
		
		
		int primeIndex = convertXPosIntoIndex(collidable);
		
		int tolerance = Math.max(collidable.getCollisionWidth() / tileWidth, 1);
		
		int startIndex = Math.max(0, primeIndex - tolerance);
		int endIndex = Math.min(blockMapByColumn.size() - 1, primeIndex + tolerance);
		
		BlockInterface candidate = null;
		
		ArrayList<SolidBlockSprite> tempList = null;
		
		for(int i = startIndex; i <= endIndex; i++) {
			tempList = blockMapByColumn.get(i);
			for(BlockInterface s: tempList) {
				if(s.isPassThrough() || s.getxPos() > collidable.getxPos()  || s.getCollisionRectMaxY() < currentRect.getMinY() || s.getCollisionRectMinY() > currentRect.getMaxY()) {
					continue;
				}
				
				if(candidate == null || s.getCollisionRectMaxX() > candidate.getCollisionRectMaxX()) {
					candidate = s;
				}
				
			}
		}
		
		

//		if(!(collidable instanceof PlayerSprite)) {
//			System.out.println("<><>DELME the currentRect is of height: " + (currentRect.getMaxY() - currentRect.getMinY()) + "; candidate left wall is: " + (candidate == null ? "null" : candidate.getCollisionRectMaxX()));
//		}
		
		
		if(candidate == null) {
			return Integer.MIN_VALUE;
		}
		
		
//		System.err.println("<><>DELME getCollisionRectMaxX is: " + candidate.getCollisionRectMaxX() + ", and its xPos is: " + candidate.getxPos());
		return candidate.getCollisionRectMaxX();
		
		
	}
	
	
	
	public BlockInterface getBottomLineBlock() {
		
		BlockInterface returnValue = new BlockInterface() {

			@Override
			public IntRect getCollisionRect() {
				return new IntRect(0, totalHeight + tileHeight * 7 / 2, totalWidth, tileHeight);
			}

			@Override
			public boolean isPlayerSpriteBlocked(CollidableObject player) {
				// it's always beneath the "bottomless pit", so the answer is always "no".
				return false;
			}

			@Override
			public void draw(Graphics g, PlayerSprite player, int panelWidth,
					int panelHeight) {
				// do nothing
				
			}

			@Override
			public void draw(Graphics g, int playerX, int playerY,
					int panelWidth, int panelHeight) {
				// do nothing
				
			}

			@Override
			public int getxPos() {
				return totalWidth / 2;
			}

			@Override
			public void setxPos(int xPos) {
				// do nothing
			}

			@Override
			public int getyPos() {
				return totalHeight + tileHeight * 4;
			}

			@Override
			public void setyPos(int yPos) {
				// do nothing
			}

			@Override
			public void primeImage(Graphics g) {
				// do nothing
			}

			@Override
			public boolean isPassThrough() {
				// why don't we call it solid?  No importa nada.
				return false;
			}

			@Override
			public int getCollisionRectMinY() {
				// TODO Auto-generated method stub
				return totalHeight + tileHeight * 7 / 2;
			}

			@Override
			public int getCollisionRectMaxY() {
				return totalHeight + tileHeight * 9 / 2;
			}

			@Override
			public int getCollisionRectMinX() {
				return 0;
			}

			@Override
			public int getCollisionRectMaxX() {
				return totalWidth;
			}

			@Override
			public int getWidth() {
				// TODO Auto-generated method stub
				return totalWidth;
			}

			@Override
			public int getHeight() {
				return tileHeight;
			}

			@Override
			public boolean isPlayerCurrentlyOnBlock(PlayerSprite player) {
				// nope.  Never.  It's below the death zone!
				return false;
			}

			@Override
			public boolean isPlayerCurrentlyBonkedOnBlock(PlayerSprite player) {
				// ha-ha, I don't think so.
				return false;
			}

			@Override
			public String getName() {
				return "the default block";
			}
			
		};
		
		return returnValue;
	}
	
	
	
	

	public static void retrieveFileLengths(BufferedReader in, String fileToLoad, String roomName, PonyPanel ponyPanel, boolean fromFiles, HashMap<String, Long> fileLengths) throws NumberFormatException, IOException {

//		boolean tileMapMode = false;

		int currentRow = 1;
		
		
			
		int fileLine = 0;
		
		String inputter = null;
		
//		blockMapByColumn = new ArrayList<ArrayList<SolidBlockSprite>>();
		
//		HashMap<Character, SolidBlockTemplate> charactersToTileGraphicFilenames = new HashMap<Character, SolidBlockTemplate>();
		
//		char tempChar;
//		String tempStr;
//		SolidBlockTemplate tempTemplate;
//		
//		tileWidth = -1;
//		tileHeight = -1;
//		
//		rows = -1;
//		columns = -1;
		
		int totalTileRowsRead = 0;
		
		while((inputter = in.readLine()) != null) {
			
			fileLine++;
			
			if(inputter.contains("#")) {
				continue;
			}
			if(inputter.contains("/staticBlocks")) {
//				System.out.println("<><>DELME and that's that for this one!  rows: " +rows + ", columns: " + columns);
				break;
			}
			
//			if(tileMapMode) {
//				
//				System.out.println("<><>DELME &&&&&&&&&&& now in tileMapMode, inputter is: <<" + inputter + ">>, columns: " + columns + ", rows: " + rows + ", tileWidth: " + tileWidth + ", tileHeight: " + tileHeight + ", charactersToTileGraphicFilenames.size: " + charactersToTileGraphicFilenames.size());
//				
//				if(inputter.length() != columns) {
//					System.out.println("Error:  at line " + fileLine + " in the input file " + fileToLoad + ", the total columns wasn't the expected " + columns + ".");
//				}
//				
//				for(int i = 0; i < inputter.length(); i++) {
//					
//					tempChar = inputter.charAt(i);
//					
//					if(!charactersToTileGraphicFilenames.containsKey(tempChar)) {
////						System.out.println("had no template for character '" + Character.toString(tempChar) + "'");
//						continue;
//					}
//					
//					tempTemplate = charactersToTileGraphicFilenames.get(tempChar);
//					
//					
//					if(tempTemplate == null) {
//						System.err.println("found the null:  " + roomName + ", trying to get char: " + tempChar);
//					}
//					
//					blockMapByColumn.get(i)
//						.add(
//							tempTemplate.createSolidBlockSprite(i * tileWidth + tileWidth/2, totalTileRowsRead * tileHeight + tileHeight/2));
//					
////					blockMap.get(i).add(new SolidBlockSprite(true, "images/" + tempStr + ".GIF", tileWidth, tileHeight, , null, false));
//					
////						if(inputter.charAt(i) == 'b') {
////							blockMap.get(i).add(new SolidBlockSprite(true, "images/tile.GIF", TILE_WIDTH, TILE_HEIGHT, i * TILE_WIDTH + TILE_WIDTH/2, currentRow * TILE_HEIGHT + TILE_HEIGHT/2, null, false));
////						} else if (inputter.charAt(i) == 'p') { 
////							blockMap.get(i).add(new SolidBlockSprite(true, "images/pass.GIF", TILE_WIDTH, TILE_HEIGHT, i * TILE_WIDTH + TILE_WIDTH/2, currentRow * TILE_HEIGHT + TILE_HEIGHT/2, null, true));
////						}
//				}
//				
//				totalTileRowsRead++;
//				
//				if(totalTileRowsRead >= rows) {
//					//we're done
//					
//					if(rows != -1 && columns != -1 && tileHeight != -1 && tileWidth != -1) {
//						totalHeight = rows * tileHeight;
//						totalWidth = columns * tileWidth;
//					}
//					
//					System.out.println("Ah, we're leaving the method THIS way.  Okay, then.  So...after it all, totalHeight: " + totalHeight + ", totalWidth: " + totalWidth + ", rows: " + rows + ", columns: " + columns + ", size of blockMap is: " + blockMapByColumn.size() + ", room name: " + roomName + " foreground null? " + (foregroundBackground == null));
//					
//					return;
//				}
//				
//				
//			} else {
				
				if(inputter.contains("blockDef:")) {
					
					//add a tile graphic to the map.
//					tempChar = inputter.charAt(9);
//					
//					tempTemplate = SolidBlockTemplate.readFromBufferedReader(in, tileWidth, tileHeight, ponyPanel, fromFiles, roomName);
//					
//					charactersToTileGraphicFilenames.put(tempChar, tempTemplate);
					
					
					SolidBlockTemplate.retrieveFileLengths(in, -1, -1, null, false, null, fileLengths);
					
				} else if(inputter.contains("tileWidth:")) {
//					tileWidth = Integer.parseInt(inputter.substring(10).trim());
				} else if(inputter.contains("tileHeight:")) {
//					tileHeight = Integer.parseInt(inputter.substring(11).trim());
				} else if(inputter.contains("totalRows:")) {
//					rows = Integer.parseInt(inputter.substring(10).trim());
				} else if(inputter.contains("totalColumns:")) {
//					columns = Integer.parseInt(inputter.substring(13).trim());
				} else if(inputter.contains("foreground:")) {
					
//					System.err.println("<><>DELME now in the foreground!");
					
					String array[] = inputter.substring(11).split("\\*");
					
					
					FileInputStream fis = new FileInputStream(array[0]);
					
					long lengthOfFile = 0L;
					
					while(fis.read() != -1)
						lengthOfFile++;
					
					fis.close();
					
					fileLengths.put(array[0], lengthOfFile);
					

//					Color foregroundBackgroundTransparent = CustomImageData.translateFileInStringToColor(array[1].trim());
//					
//					URL url = RoomData.class.getResource("/images/" + array[0] + ".GIF");
//					if(url == null && !fromFiles) {
//						continue;
//					}
//					
//					System.err.println("<><>DELME size of array: " + array.length + "; 0: <<" + array[0] + ">>, 1: <<" + array[1] + ">>");
//					
////					ImageIcon ii = new ImageIcon(url);
////					foregroundBackground = new CustomImageData(ii.getImage(), ii.getIconWidth(), ii.getIconHeight(), foregroundBackgroundTransparent, null);
//					
//					if(fromFiles) {
//						foregroundBackground = CustomImageDataIIRepository.loadImage(new File(array[0]), foregroundBackgroundTransparent, ponyPanel, roomName, fileToLoad);
//								//new CustomImageDataII(new File(array[0]), foregroundBackgroundTransparent, ponyPanel);
//					} else {
//						foregroundBackground = CustomImageDataIIRepository.loadImage("/images/" + array[0] + ".GIF", foregroundBackgroundTransparent, ponyPanel, roomName);
//								//new CustomImageDataII("/images/" + array[0] + ".GIF", foregroundBackgroundTransparent, ponyPanel);
//					}
//					
//					System.err.println("<><>DELME so is it null? " + (foregroundBackground == null));
					
					
				} else if(inputter.contains("unusedColor:")) {
//					unusedColor = CustomImageData.translateFileInStringToColor(inputter.substring(12).trim());
				} else if(inputter.contains("background:")) {
					
//					URL url = RoomData.class.getResource("images/" + inputter.substring(11).trim() + ".GIF");
//					if(url == null) {
//						continue;
//					}
//					ImageIcon ii = new ImageIcon(url);
//					backgroundBackground = ii.getImage();
					
					String theImageName = inputter.substring(11).trim();					
					
					FileInputStream fis = new FileInputStream(theImageName);
					
					long lengthOfFile = 0L;
					
					while(fis.read() != -1)
						lengthOfFile++;
					
					fis.close();
					
					fileLengths.put(theImageName, lengthOfFile);
					
					
					
//					if(fromFiles) {
//						backgroundBackground = CustomImageDataIIRepository.loadImage(new File(inputter.substring(11).trim()), null, ponyPanel, roomName, inputter.substring(11).trim());
//								//(new CustomImageDataII(new File(inputter.substring(11).trim()), null, ponyPanel)).getImage();
//					} else {
//						backgroundBackground = CustomImageDataIIRepository.loadImage("/images/" + inputter.substring(11).trim() + ".GIF", null, ponyPanel, roomName);
////						CustomImageDataII cid2 = new CustomImageDataII("/images/" + inputter.substring(11).trim() + ".GIF", null, ponyPanel);
////						backgroundBackground = cid2.getImage();
//					}
				} else if(inputter.contains("tileMap")) {
//					tileMapMode = true;
//					
//					boolean wasError = false;
//					
//					if(columns == -1) {
//						System.out.println("ERROR:  totalColumns was not set!");
//						wasError = true;
//					}
//					if(rows == -1) {
//						System.out.println("ERROR:  totalRows was not set!");
//						wasError = true;
//					}
//					if(tileWidth == -1) {
//						System.out.println("ERROR:  tileWidth was not set!");
//						wasError = true;
//					}
//					if(tileHeight == -1) {
//						System.out.println("ERROR:  tileHeight was not set!");
//						wasError = true;
//					}
//					if(charactersToTileGraphicFilenames.isEmpty()) {
//						System.out.println("ERROR:  no tile mappings were defined!");
//						wasError = true;
//					}
//					
//					if(wasError) {
//						return;
//					}
//					
//					
//					for(int i = 0; i < columns; i++) {
//						blockMapByColumn.add(new ArrayList<SolidBlockSprite>());
//					}
					
				}
				
//			}
			
//				for(int i = 0; i < inputter.length(); i++) {
//					if(inputter.charAt(i) == 'b') {
//						blockMap.get(i).add(new SolidBlockSprite(true, "images/tile.GIF", TILE_WIDTH, TILE_HEIGHT, i * TILE_WIDTH + TILE_WIDTH/2, currentRow * TILE_HEIGHT + TILE_HEIGHT/2, null, false));
//					} else if (inputter.charAt(i) == 'p') { 
//						blockMap.get(i).add(new SolidBlockSprite(true, "images/pass.GIF", TILE_WIDTH, TILE_HEIGHT, i * TILE_WIDTH + TILE_WIDTH/2, currentRow * TILE_HEIGHT + TILE_HEIGHT/2, null, true));
//					}
//				}
			
			currentRow++;
			
		}
		
//			rows = currentRow;
		
		//System.out.println("<><>DELME rows: " + rows + ", columns: " + columns);
			

//		if(rows != -1 && columns != -1 && tileHeight != -1 && tileWidth != -1) {
//			totalHeight = rows * tileHeight;
//			totalWidth = columns * tileWidth;
//			System.out.println("<><>DELME             -  - - - - - - - --  - -    at the end of the load method for StaticBlockManager, for file " + fileToLoad + ", and the rows are: " + rows + " and the columns are: " + columns);
//		} else {
//			System.out.println("<><>DELME        =============================    at the end of the load method for StaticBlockManager, for file " + fileToLoad + ", and something went wrong.  rows " + rows + ", columns " + columns + ", tileWidth " + tileWidth + ", tileHeight: " + tileHeight + ", size of charactersToTileGraphicFilenames: " + charactersToTileGraphicFilenames.size());
//		}
//		
//		
//		System.out.println("<><>DELME in any case, the currentRow is set to: " + currentRow + ", and the size of the overall map is: " + this.blockMapByColumn.size() + ", and inputter is: " + inputter + ", and file is: " + fileToLoad);
		
	}


	
}
